<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Version information
 *
 * @package    mod_choicegroup
 * @copyright  2013 Université de Lausanne
 * @author     Nicolas Dunand <Nicolas.Dunand@unil.ch>
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die;

require_once($CFG->dirroot . '/mod/choicegroup/lib.php');

if ($ADMIN->fulltree) {
    $settings->add(new admin_setting_heading('defaults', get_string('defaultsettings', 'choicegroup'), ''));

    $options = choicegroup_get_sort_options();
    $settings->add(new admin_setting_configselect('choicegroup/sortgroupsby', get_string('sortgroupsby', 'choicegroup'), '',
        CHOICEGROUP_SORTGROUPS_CREATEDATE, $options));

    $settings->add(new admin_setting_configselect(
        'choicegroup/defaultgroupdescriptionstate',
        get_string('defaultgroupdescriptionstate', 'choicegroup'),
        get_string('defaultgroupdescriptionstate_desc', 'choicegroup'),
        CHOICEGROUP_GROUPDESCRIPTIONSTATE_HIDDEN,
        [
            CHOICEGROUP_GROUPDESCRIPTIONSTATE_VISIBLE => get_string('showdescription', 'choicegroup'),
            CHOICEGROUP_GROUPDESCRIPTIONSTATE_HIDDEN => get_string('hidedescription', 'choicegroup'),
        ]
    ));
}
